param(
    [string]$ListFile = "liste.txt",
    [string]$Output   = "merged.pdf"
)

if (-not (Test-Path $ListFile)) {
    Write-Error "Die Dateiliste '$ListFile' wurde nicht gefunden."
    exit 1
}

$files = Get-Content $ListFile | Where-Object { $_.Trim() -ne "" }

foreach ($f in $files) {
    if (-not (Test-Path $f)) {
        Write-Error "Datei nicht gefunden: $f"
        exit 1
    }
}

C:\temp\sammelplot\pdftk @files cat output $Output

# --- Sammel-PDF erfolgreich erzeugt, jetzt Einzel-PDFs lschen
foreach ($f in $files) {
    try {
        Remove-Item -LiteralPath $f -ErrorAction Stop
        # Write-Host "Gelscht: $f"
    }
    catch {
        Write-Warning "Konnte nicht lschen: $f  -> $_"
    }
}

# --- Die Listen-Datei lschen ---
try {
    Remove-Item -LiteralPath $ListFile -ErrorAction Stop
    # Write-Host "Listen-Datei gelscht: $ListFile"
}
catch {
    Write-Warning "Konnte Listen-Datei nicht lschen: $ListFile -> $_"
}